/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.temporal.DurationFormat;
import com.floragunn.codova.config.temporal.TemporalAmountFormat;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.UnsupportedAttribute;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ValidatingDocNode {
    private ValidationErrors validationErrors;
    private DocNode documentNode;
    private Set<String> unconsumedAttributes;
    private Set<String> consumedAttributes = new HashSet<String>();
    private Map<String, ValidatingFunction<String, ?>> variableProviders = new HashMap();
    private Parser.Context parserContext;

    public ValidatingDocNode(Map<String, Object> document, ValidationErrors validationErrors) {
        this(DocNode.wrap(document), validationErrors);
    }

    public ValidatingDocNode(Map<String, Object> document, ValidationErrors validationErrors, Parser.Context parserContext) {
        this(DocNode.wrap(document), validationErrors, parserContext);
    }

    public ValidatingDocNode(DocNode documentNode, ValidationErrors validationErrors) {
        this(documentNode, validationErrors, (Parser.Context)null);
    }

    public ValidatingDocNode(DocNode documentNode, ValidationErrors validationErrors, Parser.Context parserContext) {
        this.documentNode = documentNode;
        this.validationErrors = validationErrors;
        this.unconsumedAttributes = new HashSet(documentNode.keySet());
        this.parserContext = parserContext;
        if (parserContext != null && parserContext.variableResolvers() != null) {
            this.variableProviders.putAll(parserContext.variableResolvers().toMap());
        }
    }

    public ValidatingDocNode(ValidatingDocNode vJsonNode, ValidationErrors validationErrors) {
        this.documentNode = vJsonNode.documentNode;
        this.validationErrors = validationErrors;
        this.unconsumedAttributes = vJsonNode.unconsumedAttributes;
        this.consumedAttributes = vJsonNode.consumedAttributes;
    }

    public ValidatingDocNode expandVariables(String name, ValidatingFunction<String, ?> variableProvider) {
        this.variableProviders.put(name, variableProvider);
        return this;
    }

    public ValidatingDocNode expandVariables(Map<String, ValidatingFunction<String, ?>> variableProviders) {
        this.variableProviders.putAll(variableProviders);
        return this;
    }

    public ValidatingDocNode expandVariables(VariableResolvers variableProviders) {
        if (variableProviders != null) {
            this.variableProviders.putAll(variableProviders.toMap());
        }
        return this;
    }

    public void used(String ... attributes) {
        for (String attribute : attributes) {
            this.used(attribute);
        }
    }

    public void used(Set<String> attributes) {
        if (attributes != null) {
            for (String attribute : attributes) {
                this.used(attribute);
            }
        }
    }

    private void used(String attribute) {
        this.unconsumedAttributes.remove(attribute);
        this.consumedAttributes.add(attribute);
        int dot = attribute.lastIndexOf(46);
        if (dot != -1) {
            String parentAttribute = attribute.substring(0, dot);
            this.usedRecursiveUp(parentAttribute);
        }
        String attributeWithDot = attribute + ".";
        for (String unconsumed : new HashSet<String>(this.unconsumedAttributes)) {
            if (!unconsumed.startsWith(attributeWithDot)) continue;
            this.usedNonRecursive(unconsumed);
        }
    }

    private void usedRecursiveUp(String attribute) {
        this.unconsumedAttributes.remove(attribute);
        this.consumedAttributes.add(attribute);
        int dot = attribute.lastIndexOf(46);
        if (dot != -1) {
            String parentAttribute = attribute.substring(0, dot);
            this.usedRecursiveUp(parentAttribute);
        }
    }

    private void usedNonRecursive(String attribute) {
        this.unconsumedAttributes.remove(attribute);
        this.consumedAttributes.add(attribute);
    }

    public DocNode getAsDocNode(String attribute) {
        this.used(attribute);
        return this.documentNode.getAsNode(attribute);
    }

    public Attribute get(String attribute) {
        if (this.documentNode.hasNonNull(attribute)) {
            this.used(attribute);
            return new Attribute(attribute, attribute, this.documentNode);
        }
        int dot = attribute.indexOf(46);
        if (dot == -1) {
            this.used(attribute);
            return new Attribute(attribute, attribute, this.documentNode);
        }
        String[] parts = attribute.split("\\.");
        DocNode currentDocumentNode = this.documentNode;
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < parts.length - 1 && currentDocumentNode != null && !currentDocumentNode.isNull(); currentDocumentNode = currentDocumentNode.getAsNode(parts[i]), ++i) {
            if (i != 0) {
                path.append('.');
            }
            path.append(parts[i]);
            this.usedNonRecursive(path.toString());
        }
        String subAttribute = parts[parts.length - 1];
        if (currentDocumentNode != null && !currentDocumentNode.isNull()) {
            String subAttributeWithDot = subAttribute + ".";
            for (String docAttribute : currentDocumentNode.keySet()) {
                if (!docAttribute.equals(subAttribute) && !docAttribute.startsWith(subAttributeWithDot)) continue;
                this.used(path + "." + docAttribute);
            }
            return new Attribute(subAttribute, attribute, currentDocumentNode);
        }
        return new Attribute(subAttribute, attribute, DocNode.EMPTY);
    }

    public Attribute get(String attribute, String ... moreAttributes) {
        String path;
        String lastAttribute;
        DocNode docNode;
        if (moreAttributes.length == 0) {
            return this.get(attribute);
        }
        if (moreAttributes.length == 1) {
            docNode = this.documentNode.getAsNode(attribute);
            lastAttribute = moreAttributes[0];
            path = attribute;
        } else {
            CharSequence[] moreAttributesButLast = Arrays.copyOfRange(moreAttributes, 0, moreAttributes.length - 1);
            docNode = this.documentNode.getAsNode(attribute, (String[])moreAttributesButLast);
            lastAttribute = moreAttributes[moreAttributes.length - 1];
            path = attribute + "." + String.join((CharSequence)".", moreAttributesButLast);
        }
        this.used(path);
        return new Attribute(lastAttribute, path, docNode);
    }

    public boolean hasNonNull(String attribute) {
        if (this.documentNode.get(attribute) != null) {
            this.used(attribute);
            return true;
        }
        int dot = attribute.indexOf(46);
        if (dot != -1) {
            this.used(attribute);
            String[] parts = attribute.split("\\.");
            DocNode currentDocumentNode = this.documentNode;
            for (int i = 0; i < parts.length - 1 && currentDocumentNode != null; currentDocumentNode = currentDocumentNode.getAsNode(parts[i]), ++i) {
            }
            if (currentDocumentNode != null && !currentDocumentNode.isNull()) {
                return true;
            }
        }
        return false;
    }

    public void checkForUnusedAttributes() {
        for (String attribute : this.unconsumedAttributes) {
            this.validationErrors.add(new UnsupportedAttribute(attribute, this.documentNode.get(attribute) != null ? this.documentNode.get(attribute).toString() : null, null));
        }
    }

    public DocNode getDocumentNode() {
        return this.documentNode;
    }

    public void throwExceptionForPresentErrors() throws ConfigValidationException {
        this.validationErrors.throwExceptionForPresentErrors();
    }

    private static DayOfWeek getDayOfWeek(String string) throws ConfigValidationException {
        switch (string) {
            case "sunday": 
            case "sun": {
                return DayOfWeek.SUNDAY;
            }
            case "monday": 
            case "mon": {
                return DayOfWeek.MONDAY;
            }
            case "tuesday": 
            case "tue": {
                return DayOfWeek.TUESDAY;
            }
            case "wednesday": 
            case "wed": {
                return DayOfWeek.WEDNESDAY;
            }
            case "thursday": 
            case "thu": {
                return DayOfWeek.THURSDAY;
            }
            case "friday": 
            case "fri": {
                return DayOfWeek.FRIDAY;
            }
            case "saturday": 
            case "sat": {
                return DayOfWeek.SATURDAY;
            }
        }
        throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"mon|tue|wed|thu|fri|sat|sun"));
    }

    private static boolean isScalar(Object object) {
        return object instanceof String || object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof Enum;
    }

    public class IntegerListAttribute
    extends NumberListAttribute<Integer> {
        IntegerListAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public IntegerListAttribute withDefault(List<Integer> defaultValue) {
            super.withDefault(defaultValue);
            return this;
        }

        @Override
        protected Integer convertFromNumber(Number number) {
            if (number instanceof Integer) {
                return (Integer)number;
            }
            return number.intValue();
        }

        public IntegerListAttribute inRange(int min, int max) {
            return (IntegerListAttribute)super.inRange(min, max);
        }

        public ImmutableList<Integer> ofIntegers() {
            return this.ofNumbers();
        }
    }

    public abstract class NumberListAttribute<T extends Number>
    extends AbstractAttribute<NumberListAttribute<T>> {
        private ImmutableList<T> defaultValue;

        NumberListAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public NumberListAttribute<T> withDefault(List<T> defaultValue) {
            this.defaultValue = defaultValue != null ? ImmutableList.of(defaultValue) : null;
            return this;
        }

        public NumberListAttribute<T> validatedBy(java.util.function.Predicate<T> validationPredicate) {
            ImmutableList<T> list = this.ofNumbers();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Number number = (Number)list.get(i);
                    if (validationPredicate.test(number)) continue;
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, number, (Object)this.expected));
                }
            }
            return this;
        }

        public NumberListAttribute<T> inRange(T min, T max) {
            ImmutableList<T> list = this.ofNumbers();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Number number = (Number)list.get(i);
                    if (number.longValue() >= ((Number)min).longValue() && number.longValue() <= ((Number)max).longValue()) continue;
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, number, (Object)("A number between " + min + " and " + max)));
                }
            }
            return this;
        }

        protected abstract T convertFromNumber(Number var1);

        protected ImmutableList<T> ofNumbers() {
            Object value = this.documentNode.get(this.name);
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                ImmutableList.Builder result = new ImmutableList.Builder(collection.size());
                int i = 0;
                for (Object o : collection) {
                    if (o instanceof Number) {
                        result.add(this.convertFromNumber((Number)o));
                    } else {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, o, (Object)"A number"));
                    }
                    ++i;
                }
                return result.build();
            }
            if (value instanceof Number) {
                return ImmutableList.of(this.convertFromNumber((Number)value));
            }
            if (value != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)"A number"));
                return this.defaultValue;
            }
            return this.defaultValue;
        }
    }

    public class StringListAttribute
    extends AbstractAttribute<StringListAttribute> {
        private ImmutableList<String> defaultValue;

        StringListAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public StringListAttribute withDefault(List<String> defaultValue) {
            this.defaultValue = defaultValue != null ? ImmutableList.of(defaultValue) : null;
            return this;
        }

        public StringListAttribute withDefault(String ... defaultValue) {
            return this.withDefault((List<String>)ImmutableList.ofArray((Object[])defaultValue));
        }

        public StringListAttribute validatedBy(java.util.function.Predicate<String> validationPredicate) {
            ImmutableList<String> list = this.ofStrings();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string = (String)list.get(i);
                    if (validationPredicate.test(string)) continue;
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, (Object)string, (Object)this.expected));
                }
            }
            return this;
        }

        public ImmutableList<String> ofStrings() {
            if (this.documentNode.hasNonNull(this.name)) {
                return this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            }
            return this.defaultValue;
        }
    }

    public class ListAttribute
    extends AbstractAttribute<ListAttribute> {
        private boolean emptyListAsDefault;

        ListAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
            this.emptyListAsDefault = false;
        }

        public ListAttribute minElements(int minElements) {
            ImmutableList<String> list = this.documentNode.getAsListOfStrings(this.name);
            if (list != null && list.size() < minElements) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), list, (Object)("The list must contain at least " + minElements + " elements")));
            }
            return this;
        }

        public ListAttribute withEmptyListAsDefault() {
            this.emptyListAsDefault = true;
            return this;
        }

        public StringListAttribute withDefault(String ... defaultValue) {
            return new StringListAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault(Arrays.asList(defaultValue));
        }

        public StringListAttribute validatedBy(java.util.function.Predicate<String> validationPredicate) {
            return new StringListAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault((List<String>)this.getDefault()).validatedBy(validationPredicate);
        }

        public IntegerListAttribute inRange(int min, int max) {
            return ((IntegerListAttribute)new IntegerListAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault((List)this.getDefault())).inRange(min, max);
        }

        public ImmutableList<String> ofStrings() {
            return new StringListAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault((List<String>)this.getDefault()).ofStrings();
        }

        public ImmutableList<Integer> ofIntegers() {
            return ((IntegerListAttribute)new IntegerListAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault((List)this.getDefault())).ofIntegers();
        }

        public List<DayOfWeek> ofDayOfWeek() {
            ImmutableList<String> values = this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            if (values != null) {
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add((Object)ValidatingDocNode.getDayOfWeek((String)values.get(i)));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public List<JsonPath> ofJsonPath() {
            ImmutableList<String> values = this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            if (values != null) {
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add((Object)JsonPath.compile((String)((String)values.get(i)), (Predicate[])new Predicate[0]));
                        continue;
                    }
                    catch (InvalidPathException e) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, values.get(i), (Object)"JSON Path").message(e.getMessage()).cause(e));
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public ImmutableList<Template<String>> ofTemplates() {
            ImmutableList<String> values = this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            if (values != null) {
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add(Template.string((String)values.get(i)));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public <T> ImmutableList<Template<T>> ofTemplates(ValidatingFunction<String, T> parser) {
            ImmutableList<String> values = this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            if (values != null) {
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add(new Template<T>((String)values.get(i), parser));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public ImmutableList<URI> ofURIs() {
            ImmutableList<String> values = this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            if (values != null) {
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add((Object)new URI((String)values.get(i)));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), values.get(i), (Object)"A URI"));
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public <T> ImmutableList<T> ofObjectsParsedByString(ValidatingFunction<String, T> parser) {
            ImmutableList<String> values = this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            if (values != null) {
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add(parser.apply((String)values.get(i)));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                        continue;
                    }
                    catch (Exception e) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, values.get(i), (Object)this.expected).cause(e));
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public <T> ImmutableList<T> ofObjectsParsedBy(ValidatingFunction<DocNode, T> parser) {
            if (this.documentNode.hasNonNull(this.name)) {
                ImmutableList<DocNode> values = this.documentNode.getAsListOfNodes(this.name);
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add(parser.apply((DocNode)values.get(i)));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                        continue;
                    }
                    catch (Exception e) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, values.get(i), (Object)this.expected).cause(e));
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public <T> ImmutableList<T> ofObjectsParsedBy(Parser<T, Parser.Context> parser) {
            if (this.documentNode.hasNonNull(this.name)) {
                ImmutableList<DocNode> values = this.documentNode.getAsListOfNodes(this.name);
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        result.add(parser.parse((DocNode)values.get(i), ValidatingDocNode.this.parserContext));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                        continue;
                    }
                    catch (Exception e) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, values.get(i), (Object)this.expected).cause(e));
                    }
                }
                return result.build();
            }
            return this.getDefault();
        }

        public <T> ValidationResult<ImmutableList<T>> ofObjectsParsedBy(Parser.ReturningValidationResult<T, Parser.Context> parser) {
            if (this.documentNode.hasNonNull(this.name)) {
                ImmutableList<DocNode> values = this.documentNode.getAsListOfNodes(this.name);
                ImmutableList.Builder result = new ImmutableList.Builder(values.size());
                ValidationErrors resultValidationErrors = null;
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        ValidationResult<T> subResult = parser.parse((DocNode)values.get(i), ValidatingDocNode.this.parserContext);
                        if (subResult.hasResult()) {
                            result.add(subResult.peek());
                        }
                        if (!subResult.hasErrors()) continue;
                        if (resultValidationErrors == null) {
                            resultValidationErrors = new ValidationErrors();
                        }
                        resultValidationErrors.add(String.valueOf(i), subResult.getValidationErrors());
                        continue;
                    }
                    catch (Exception e) {
                        resultValidationErrors.add(new InvalidAttributeValue(String.valueOf(i), values.get(i), (Object)this.expected).cause(e));
                    }
                }
                if (resultValidationErrors.hasErrors()) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), resultValidationErrors);
                }
                return new ValidationResult<ImmutableList<T>>(result.build(), resultValidationErrors);
            }
            return new ValidationResult<ImmutableList<T>>(this.getDefault());
        }

        private <T> ImmutableList<T> getDefault() {
            if (this.emptyListAsDefault) {
                return ImmutableList.empty();
            }
            return null;
        }
    }

    public class EnumAttribute<E extends Enum<E>>
    extends AbstractAttribute<EnumAttribute<E>> {
        private E defaultValue;

        EnumAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public EnumAttribute<E> withDefault(E defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public E asEnum(Class<E> enumClass) {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return this.defaultValue;
            }
            if (object instanceof String) {
                String value = (String)object;
                for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                    if (!value.equalsIgnoreCase(e.name())) continue;
                    return (E)e;
                }
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, enumClass));
            return this.defaultValue;
        }
    }

    public class TypedAttribute<T>
    extends AbstractAttribute<StringAttribute> {
        private T defaultValue;
        private Function<T, ValidationErrors> validationFunction;

        TypedAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public TypedAttribute<T> withDefault(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public TypedAttribute<T> validatedBy(Function<T, ValidationErrors> validationFunction) {
            this.validationFunction = validationFunction;
            return this;
        }

        public T byString(ValidatingFunction<String, T> parser) {
            Object object = this.expandVariable(this.documentNode.getAsString(this.name));
            if (object != null) {
                try {
                    ValidationErrors resultValidationErrors;
                    T result = parser.apply(String.valueOf(object));
                    if (this.validationFunction != null && (resultValidationErrors = this.validationFunction.apply(result)) != null) {
                        ValidatingDocNode.this.validationErrors.add(this.name, resultValidationErrors);
                    }
                    return result;
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.name, e);
                    return this.defaultValue;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)this.expected));
                    return this.defaultValue;
                }
            }
            return this.defaultValue;
        }

        public T by(ValidatingFunction<DocNode, T> parser) {
            DocNode value = this.expandVariable(this.documentNode.getAsNode(this.name));
            if (value != null && !value.isNull()) {
                try {
                    ValidationErrors resultValidationErrors;
                    T result = parser.apply(value);
                    if (this.validationFunction != null && (resultValidationErrors = this.validationFunction.apply(result)) != null) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), resultValidationErrors);
                    }
                    return result;
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return this.defaultValue;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)this.expected).cause(e));
                    return this.defaultValue;
                }
            }
            return this.defaultValue;
        }

        public T by(Parser<T, Parser.Context> parser) {
            DocNode value = this.expandVariable(this.documentNode.getAsNode(this.name));
            if (value != null && !value.isNull()) {
                try {
                    return parser.parse(value, ValidatingDocNode.this.parserContext);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return this.defaultValue;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)this.expected).cause(e));
                    return this.defaultValue;
                }
            }
            return this.defaultValue;
        }
    }

    public class DurationAttribute
    extends AbstractAttribute<DurationAttribute> {
        private Duration defaultValue;

        DurationAttribute(String name, Duration defaultValue, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
            this.defaultValue = defaultValue;
        }

        public DurationAttribute withDefault(Duration defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Duration asDuration() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return DurationFormat.INSTANCE.parse((String)object);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return this.defaultValue;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"<Weeks>w? <Days>d? <Hours>h? <Minutes>m? <Seconds>s? <Milliseconds>ms?"));
                return this.defaultValue;
            }
            return this.defaultValue;
        }
    }

    public class URIAttribute
    extends AbstractAttribute<URIAttribute> {
        private URI defaultValue;

        URIAttribute(String name, URI defaultValue, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
            this.defaultValue = defaultValue;
        }

        public URIAttribute withDefault(URI defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public URI asURI() {
            Object object = this.expandVariable(this.documentNode.getAsString(this.name));
            if (object instanceof String) {
                try {
                    return new URI((String)object);
                }
                catch (URISyntaxException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A URI"));
                    return this.defaultValue;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A URI"));
                return this.defaultValue;
            }
            return this.defaultValue;
        }

        public URI asAbsoluteURI() {
            URI uri = this.asURI();
            if (uri != this.defaultValue && !uri.isAbsolute()) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), uri, (Object)"URI").message("Must be an absolute URI"));
            }
            return uri;
        }
    }

    public class BooleanAttribute
    extends AbstractAttribute<NumberAttribute> {
        private final boolean defaultValue;

        BooleanAttribute(String name, boolean defaultValue, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
            this.defaultValue = defaultValue;
        }

        public boolean asBoolean() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return this.defaultValue;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"true or false"));
            return this.defaultValue;
        }
    }

    public class NumberAttribute
    extends AbstractAttribute<NumberAttribute> {
        private Number defaultValue;
        private boolean allowNumericStrings;

        NumberAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public NumberAttribute withDefault(Number defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public NumberAttribute allowingNumericStrings() {
            this.allowNumericStrings = true;
            return this;
        }

        public Number asNumber() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return this.defaultValue;
            }
            if (object instanceof Number) {
                return (Number)object;
            }
            if (this.allowNumericStrings && object instanceof String) {
                return this.parseString((String)object);
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A numeric value"));
            return this.defaultValue;
        }

        public int asInt() {
            Number number = this.asNumber();
            if (number != null) {
                return number.intValue();
            }
            return 0;
        }

        public Integer asInteger() {
            Number number = this.asNumber();
            if (number instanceof Integer) {
                return (Integer)number;
            }
            if (number != null) {
                return number.intValue();
            }
            return null;
        }

        public long asLong() {
            Number number = this.asNumber();
            if (number != null) {
                return number.longValue();
            }
            return 0L;
        }

        public float asFloat() {
            Number number = this.asNumber();
            if (number != null) {
                return number.floatValue();
            }
            return 0.0f;
        }

        public double asDouble() {
            Number number = this.asNumber();
            if (number != null) {
                return number.doubleValue();
            }
            return 0.0;
        }

        private Number parseString(String string) {
            Number result = Longs.tryParse((String)string);
            if (result != null) {
                return result;
            }
            result = Doubles.tryParse((String)string);
            if (result != null) {
                return result;
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), (Object)string, (Object)"A numeric value"));
            return this.defaultValue;
        }
    }

    public class StringAttribute
    extends AbstractAttribute<StringAttribute> {
        private String defaultValue;

        StringAttribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public StringAttribute withDefault(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public StringAttribute validatedBy(java.util.function.Predicate<String> validationPredicate) {
            Object value = this.expandVariable(this.documentNode.getAsString(this.name));
            if (value != null && ValidatingDocNode.isScalar(value) && !validationPredicate.test(String.valueOf(value))) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)this.expected));
            }
            return this;
        }

        public String asString() {
            Object value = this.expandVariable(this.documentNode.get(this.name));
            if (value == null) {
                return this.defaultValue;
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (ValidatingDocNode.isScalar(value)) {
                return String.valueOf(value);
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)"A scalar string value"));
            return this.defaultValue;
        }

        public Template<String> asTemplate() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return new Template<String>((String)object, s -> s);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                }
            } else if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"Template expression"));
            }
            try {
                return new Template<String>(this.defaultValue, s -> s);
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException("Invalid default value: " + this.defaultValue);
            }
        }
    }

    public class Attribute
    extends AbstractAttribute<Attribute> {
        Attribute(String name, String fullAttributePath, DocNode documentNode) {
            super(name, fullAttributePath, documentNode);
        }

        public Attribute required() {
            Object value = this.documentNode.get(this.name);
            if (value == null) {
                ValidatingDocNode.this.validationErrors.add(new MissingAttribute(this.getAttributePathForValidationError(), this.documentNode));
            }
            return this;
        }

        public Attribute required(boolean required) {
            if (required) {
                return this.required();
            }
            return this;
        }

        public StringAttribute withDefault(String defaultValue) {
            return (StringAttribute)new StringAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault(defaultValue).expected(this.expected);
        }

        public StringAttribute validatedBy(java.util.function.Predicate<String> validationPredicate) {
            return ((StringAttribute)new StringAttribute(this.name, this.fullAttributePath, this.documentNode).expected(this.expected)).validatedBy(validationPredicate);
        }

        public NumberAttribute withDefault(Number defaultValue) {
            return (NumberAttribute)new NumberAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault(defaultValue).expected(this.expected);
        }

        public BooleanAttribute withDefault(boolean defaultValue) {
            return new BooleanAttribute(this.name, defaultValue, this.fullAttributePath, this.documentNode);
        }

        public URIAttribute withDefault(URI defaultValue) {
            return new URIAttribute(this.name, defaultValue, this.fullAttributePath, this.documentNode);
        }

        public DurationAttribute withDefault(Duration defaultValue) {
            return new DurationAttribute(this.name, defaultValue, this.fullAttributePath, this.documentNode);
        }

        public <T> TypedAttribute<T> withDefault(T defaultValue) {
            return new TypedAttribute<T>(this.name, this.fullAttributePath, this.documentNode).withDefault(defaultValue);
        }

        public <T> TypedAttribute<T> validatedBy(Function<T, ValidationErrors> validationFunction) {
            return new TypedAttribute<T>(this.name, this.fullAttributePath, this.documentNode).validatedBy(validationFunction);
        }

        public <E extends Enum<E>> EnumAttribute<E> withDefault(E defaultValue) {
            return new EnumAttribute<E>(this.name, this.fullAttributePath, this.documentNode).withDefault(defaultValue);
        }

        public ListAttribute asList() {
            return new ListAttribute(this.name, this.fullAttributePath, this.documentNode);
        }

        public StringListAttribute withListDefault(String ... defaultValueStrings) {
            return new StringListAttribute(this.name, this.fullAttributePath, this.documentNode).withDefault(defaultValueStrings);
        }

        public String asString() {
            Object value = this.expandVariable(this.documentNode.get(this.name));
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (ValidatingDocNode.isScalar(value)) {
                return String.valueOf(value);
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)"A scalar string value"));
            return null;
        }

        public Object asAnything() {
            return this.expandVariable(this.documentNode.get(this.name));
        }

        public DocNode asDocNode() {
            Object object = this.asAnything();
            if (object != null) {
                return DocNode.wrap(object);
            }
            return DocNode.NULL;
        }

        public ValidatingDocNode asValidatingDocNode() {
            DocNode docNode = this.asDocNode();
            ValidationErrors attributeValidationErrors = new ValidationErrors(ValidatingDocNode.this.validationErrors, this.name);
            return new ValidatingDocNode(docNode, attributeValidationErrors);
        }

        public ImmutableList<String> asListOfStrings() {
            if (this.documentNode.hasNonNull(this.name)) {
                return this.expandVariablesForStrings((List<String>)this.documentNode.getAsListOfStrings(this.name));
            }
            return null;
        }

        public Number asNumber() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return (Number)object;
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A numeric value"));
            return null;
        }

        public int asInt() {
            Number number = this.asNumber();
            if (number != null) {
                return number.intValue();
            }
            return 0;
        }

        public Integer asInteger() {
            Number number = this.asNumber();
            if (number instanceof Integer) {
                return (Integer)number;
            }
            if (number != null) {
                return number.intValue();
            }
            return null;
        }

        public long asPrimitiveLong() {
            Number number = this.asNumber();
            if (number != null) {
                return number.longValue();
            }
            return 0L;
        }

        public Long asLong() {
            Number number = this.asNumber();
            if (number instanceof Long) {
                return (Long)number;
            }
            if (number != null) {
                return number.longValue();
            }
            return null;
        }

        public BigDecimal asBigDecimal() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return null;
            }
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof Integer || object instanceof Long) {
                return new BigDecimal(((Number)object).longValue());
            }
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            if (object instanceof String) {
                try {
                    return new BigDecimal((String)object);
                }
                catch (NumberFormatException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"number"));
                    return null;
                }
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"number"));
            return null;
        }

        public Boolean asBoolean() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return null;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"true or false"));
            return null;
        }

        public URI asURI() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return new URI((String)object);
                }
                catch (URISyntaxException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A URI"));
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A URI"));
                return null;
            }
            return null;
        }

        public URI asAbsoluteURI() {
            URI uri = this.asURI();
            if (uri != null && !uri.isAbsolute()) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), uri, (Object)"URI").message("Must be an absolute URI"));
            }
            return uri;
        }

        public URI asBaseURL() {
            URI uri = this.asURI();
            if (uri != null) {
                try {
                    String path;
                    if (!uri.isAbsolute()) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), uri, (Object)"Base URL").message("Must be an absolute URL"));
                    }
                    if (uri.getRawQuery() != null) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), uri, (Object)"Base URL").message("Cannot use query parameters for base URLs"));
                    }
                    if (uri.getRawFragment() != null) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), uri, (Object)"Base URL").message("Cannot use fragments for base URLs"));
                    }
                    if ((path = uri.getRawPath()) == null) {
                        path = "/";
                    } else if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    return new URI(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), path, null, null);
                }
                catch (URISyntaxException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), uri, (Object)"Base URL"));
                    return null;
                }
            }
            return null;
        }

        public <E extends Enum<E>> E asEnum(Class<E> enumClass) {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                String value = (String)object;
                for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                    if (!value.equalsIgnoreCase(e.name())) continue;
                    return (E)e;
                }
            }
            ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, enumClass));
            return null;
        }

        public DayOfWeek asDayOfWeek() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return ValidatingDocNode.getDayOfWeek((String)object);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"mon|tue|wed|thu|fri|sat|sun"));
                return null;
            }
            return null;
        }

        public Pattern asPattern() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return Pattern.compile((String)object);
                }
                catch (PatternSyntaxException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"Regular expression"));
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"Regular expression"));
                return null;
            }
            return null;
        }

        public Template<String> asTemplate() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return new Template<String>((String)object, s -> s);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"Template expression"));
                return null;
            }
            return null;
        }

        public <T> Template<T> asTemplate(ValidatingFunction<String, T> parser) {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return new Template<T>((String)object, parser);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"Template expression"));
                return null;
            }
            return null;
        }

        public ImmutableMap<String, Object> asMap() {
            DocNode value = this.documentNode.getAsNode(this.name);
            if (value == null || value.isNull()) {
                return null;
            }
            if (!value.isMap()) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)"JSON object"));
            }
            return value.toMap();
        }

        public TemporalAmount asTemporalAmount() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return TemporalAmountFormat.INSTANCE.parse((String)object);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"<Years>y? <Months>M? <Weeks>w? <Days>d?  |  <Days>d? <Hours>h? <Minutes>m? <Seconds>s? <Milliseconds>ms?"));
                return null;
            }
            return null;
        }

        public Duration asDuration() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return DurationFormat.INSTANCE.parse((String)object);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"<Weeks>w? <Days>d? <Hours>h? <Minutes>m? <Seconds>s? <Milliseconds>ms?"));
                return null;
            }
            return null;
        }

        public JsonPath asJsonPath() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return JsonPath.compile((String)((String)object), (Predicate[])new Predicate[0]);
                }
                catch (InvalidPathException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"JSON Path").message(e.getMessage()).cause(e));
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"JSON Path"));
                return null;
            }
            return null;
        }

        public ZoneId asTimeZoneId() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof String) {
                try {
                    return ZoneId.of((String)object);
                }
                catch (DateTimeException e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A time zone ID").cause(e));
                    return null;
                }
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A time zone ID"));
                return null;
            }
            return null;
        }

        public Instant asInstantFromEpochMilli() {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object instanceof Number) {
                return Instant.ofEpochMilli(((Number)object).longValue());
            }
            if (object != null) {
                ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)"A number representing a time stamp in milliseconds from epoch"));
                return null;
            }
            return null;
        }

        public <T> T byString(ValidatingFunction<String, T> parser) {
            Object object = this.expandVariable(this.documentNode.get(this.name));
            if (object != null) {
                try {
                    String string = object instanceof String ? (String)object : (object instanceof Boolean || object instanceof Number || object instanceof Character ? object.toString() : DocWriter.json().writeAsString(object));
                    return parser.apply(string);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), object, (Object)this.expected).cause(e));
                    return null;
                }
            }
            return null;
        }

        public <T> T by(Parser.ReturningValidationResult<T, Parser.Context> parser) {
            DocNode value = this.expandVariable(this.documentNode.getAsNode(this.name));
            if (value != null && !value.isNull()) {
                try {
                    ValidationResult<T> result = parser.parse(value, ValidatingDocNode.this.parserContext);
                    if (result.hasErrors()) {
                        ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), result.getValidationErrors());
                    }
                    return result.peek();
                }
                catch (Exception e) {
                    ValidationErrors localErrors = new ValidationErrors(new InvalidAttributeValue(null, value, (Object)this.expected).cause(e));
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), localErrors);
                    return null;
                }
            }
            return null;
        }

        public <T> T by(ValidatingFunction<DocNode, T> parser) {
            DocNode value = this.expandVariable(this.documentNode.getAsNode(this.name));
            if (value != null && !value.isNull()) {
                try {
                    return parser.apply(value);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)this.expected).cause(e));
                    return null;
                }
            }
            return null;
        }

        public <T> T by(Parser<T, Parser.Context> parser) {
            DocNode value = this.expandVariable(this.documentNode.getAsNode(this.name));
            if (value != null && !value.isNull()) {
                try {
                    return parser.parse(value, ValidatingDocNode.this.parserContext);
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)this.expected).cause(e));
                    return null;
                }
            }
            return null;
        }

        public <T> ImmutableList<T> viaStringsAsList(ValidatingFunction<String, T> parser) {
            try {
                return this.documentNode.getAsList(this.name, parser, this.expected);
            }
            catch (ConfigValidationException e) {
                ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                return ImmutableList.empty();
            }
        }

        public <T> ImmutableList<T> asList(ValidatingFunction<DocNode, T> parser) {
            ImmutableList<DocNode> listOfNodes = this.documentNode.getAsListOfNodes(this.name);
            ImmutableList.Builder result = new ImmutableList.Builder(listOfNodes.size());
            int i = 0;
            for (DocNode listNode : listOfNodes) {
                try {
                    result.add((Object)parser.apply(listNode));
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError() + "." + i, e);
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError() + "." + i, listNode, (Object)this.expected).cause(e));
                }
                ++i;
            }
            return result.build();
        }
    }

    public abstract class AbstractAttribute<T> {
        protected final String name;
        protected final String fullAttributePath;
        protected final DocNode documentNode;
        protected String expandedVariable;
        protected String expected;

        protected AbstractAttribute(String name, String fullAttributePath, DocNode documentNode) {
            this.name = name;
            this.fullAttributePath = fullAttributePath;
            this.documentNode = documentNode;
        }

        public T expected(String expected) {
            this.expected = expected;
            return (T)this;
        }

        protected String getAttributePathForValidationError() {
            if (this.expandedVariable == null) {
                return this.fullAttributePath;
            }
            return this.fullAttributePath + "." + this.expandedVariable;
        }

        protected Object expandVariable(Object value) {
            if (value == null) {
                return null;
            }
            if (ValidatingDocNode.this.variableProviders.isEmpty()) {
                return value;
            }
            if (value instanceof List) {
                return this.expandVariables((List)value);
            }
            if (!(value instanceof String)) {
                return value;
            }
            String string = (String)value;
            if (string.startsWith("#{") && string.endsWith("}")) {
                ValidatingFunction variableProvider;
                String name = string.substring(2, string.length() - 1);
                int colon = name.indexOf(58);
                if (colon != -1) {
                    variableProvider = (ValidatingFunction)ValidatingDocNode.this.variableProviders.get(name.substring(0, colon));
                    name = name.substring(colon + 1);
                } else {
                    variableProvider = (ValidatingFunction)ValidatingDocNode.this.variableProviders.get("default");
                }
                if (variableProvider == null) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)"Invalid variable definition"));
                    return value;
                }
                try {
                    Object newValue = variableProvider.apply(name);
                    if (newValue == null) {
                        ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)("The variable " + value + " does not exist")));
                        return null;
                    }
                    this.expandedVariable = string;
                    return newValue;
                }
                catch (ConfigValidationException e) {
                    ValidatingDocNode.this.validationErrors.add(this.getAttributePathForValidationError(), e);
                    return null;
                }
                catch (Exception e) {
                    ValidatingDocNode.this.validationErrors.add(new InvalidAttributeValue(this.getAttributePathForValidationError(), value, (Object)("Error while retrieving variable: " + e)));
                    return null;
                }
            }
            return value;
        }

        protected DocNode expandVariable(DocNode docNode) {
            if (docNode == null) {
                return null;
            }
            Object value = docNode.get(null);
            Object newValue = this.expandVariable(value);
            if (newValue == value) {
                return docNode;
            }
            return DocNode.wrap(newValue);
        }

        protected ImmutableList<?> expandVariables(List<?> values) {
            if (values == null) {
                return null;
            }
            if (values.isEmpty() || ValidatingDocNode.this.variableProviders.isEmpty()) {
                return ImmutableList.of(values);
            }
            ImmutableList.Builder result = new ImmutableList.Builder(values.size());
            for (Object value : values) {
                Object expandedValue = this.expandVariable(value);
                if (expandedValue == null) continue;
                result.add(expandedValue);
            }
            return result.build();
        }

        protected ImmutableList<String> expandVariablesForStrings(List<String> values) {
            if (values == null) {
                return null;
            }
            if (values.isEmpty() || ValidatingDocNode.this.variableProviders.isEmpty()) {
                return ImmutableList.of(values);
            }
            ImmutableList.Builder result = new ImmutableList.Builder(values.size());
            for (String value : values) {
                Object expandedValue = this.expandVariable(value);
                if (expandedValue == null) continue;
                result.add((Object)String.valueOf(expandedValue));
            }
            return result.build();
        }
    }
}

